package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Remo_FR_door extends FrontDoor
{
	public Remo_FR_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Remo front right door";

		value = 250;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.remo:0x000000BEr, "FR window", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000CBr, "R mirror", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000BEr, "FR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000CBr, "R mirror", actcolor, optical, power );
		}
	}
}
